class DM_SB extends TournamentScoreBoard;

#exec Texture Import File=Textures\Tile_Pipe2.bmp Name=Tile_Pipe2 Group=ScoreBoard MIPS=ON
#exec Texture Import File=Textures\NoTalkTexture.bmp Name=NoTalkTexture Group=ScoreBoard MIPS=ON
#exec Texture Import File=Textures\FrameDot.bmp Name=FrameDot Group=ScoreBoard MIPS=ON

var bool bSetStart;
var float Speed, a, b;

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;

	if ( GRI.GameEndedComments != "" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, 0);
		Canvas.DrawText(GRI.GameEndedComments, True);
		}
	else
		{
		DrawVictoryConditions(Canvas);
		}
	Canvas.bCenter = False;
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.SetPos(0, 0);
	Canvas.DrawText(TGRI.GameName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.SetPos(0, 32);

	if ( TGRI.FragLimit > 0 )
	{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, 54);
	}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawPlayerStats(Canvas Canvas, PlayerReplicationInfo PRInfo, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;
local int Eff;
local String ImportTexture;
local Texture FLag;

	//Setup ScoreBox:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor.R = 60;
	Canvas.DrawColor.G = 60;
	Canvas.DrawColor.B = 60;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, YOffset);
	Canvas.DrawTile(texture'FrameDot', 512, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, YOffset + 40);
	Canvas.DrawTile(texture'FrameDot', 512, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 1, 39, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 255, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 1, 39, 0, 0, 4, 4);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 30;
	Canvas.DrawColor.G = 30;
	Canvas.DrawColor.B = 30;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 255, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 510, 39, 0, 0, 4, 4);

	PlayerOwner = PlayerPawn(Owner);

	Canvas.DrawColor = WhiteColor;
	bLocalPlayer = (PRInfo.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.Style = ERenderStyle.STY_Normal;

	//Draw Country Flag:
	if ( PRInfo.bIsABot )
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 - 308, YOffset + 4);
		Canvas.DrawTile(Texture'BotFlag', 48, 32, 0, 0, 48, 32);
		}
	else if ( PRI(PRInfo).Country != "" )
		{
		ImportTexture = "SS_18+v2.Flags."$PRI(PRInfo).Country;
		Flag = texture(DynamicLoadObject(ImportTexture, class'Texture'));
		Canvas.SetPos(Canvas.ClipX * 0.5 - 308, YOffset + 4);
		if ( Flag != None )
			Canvas.DrawTile(Flag, 48, 32, 0, 0, 48, 32);
		}
	else
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 - 308, YOffset + 4);
		Canvas.DrawTile(Texture'NoFlag', 48, 32, 0, 0, 48, 32);
		}


	if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = GreenColor;

	Canvas.SetPos(Canvas.ClipX * 0.5 - 214, YOffset + 2);
	Canvas.DrawText(PRInfo.PlayerName, False);

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 140, YOffset );
	Canvas.DrawTile(texture'Icon_Skull', 22, 22, 0, 0, 128, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 210, YOffset );
	Canvas.DrawTile(texture'tombstone', 24, 24, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos( Canvas.ClipX * 0.5 + 162, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Score), false );

	Canvas.SetPos( Canvas.ClipX * 0.5 + 230, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Deaths), false );


	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetAReallySmallFont(1920);//Canvas.ClipX
	Canvas.StrLen("TEST", XL, YL);
	YL -= 4;

	// Draw Time
	Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRInfo.StartTime)/60);
	Canvas.TextSize( TimeString$": 999", XL3, YL3 );
	Canvas.SetPos( Canvas.ClipX * 0.5 + 260, YOffset );
	Canvas.DrawText( TimeString$":"@Time, false );

	// Draw FPH
	Canvas.TextSize( FPHString$": 999", XL2, YL2 );
	Canvas.SetPos( Canvas.ClipX * 0.5 + 260, YOffset + YL );
	Canvas.DrawText( FPHString$": "@int(60 * PRInfo.Score/Time), false );

	// Draw Ping
	if ( !PRInfo.bIsABot )
		{
		Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);
		Canvas.SetPos( Canvas.ClipX * 0.5 - 214, YOffset + 2.75*YL );
		Canvas.DrawText("Headshots:"@PRI(PRInfo).Headshots$", Telefrags:"@PRI(PRInfo).Telefrags$", Suicides:"@PRI(PRInfo).Suicides, false );
		Canvas.Font = MyFonts.GetAReallySmallFont(Canvas.ClipX);
		Canvas.SetPos( Canvas.ClipX * 0.5 +260, YOffset + 3*YL );
		Canvas.DrawText( PingString$":"@PRInfo.Ping, false );
		}

	// Draw EFF
	if ( PRInfo.Score < 0 )
		Eff = 0;
	else
		Eff = PRInfo.Score / (PRInfo.Score + PRInfo.Deaths) * 100;
	Canvas.TextSize( "EFF: 100%", XL2, YL2 );
	Canvas.SetPos( Canvas.ClipX * 0.5 + 260, YOffset + 2*YL );
	Canvas.DrawText( "EFF: "@Eff$"%", false );

	// Draw Talk Texture:
	if ( PRInfo.TalkTexture != None )
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 - 254 , YOffset + 2 );
		Canvas.DrawTile(PRInfo.TalkTexture, 37, 37, 0, 0, 64, 64);
		}
	else
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 - 254 , YOffset + 2 );
		Canvas.DrawTile(texture'NoTalkTexture', 37, 37, 0, 0, 64, 64);
		}
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

simulated function Tick(float DeltaTime)
{
	Super.Tick(DeltaTime);

	a -= Speed;
	if ( a < 0 )
		{
		a = 6.283185307;
		}
	b -= Speed;
	if ( b < 0 )
		{
		b = 6.283185307;
		}
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	DrawHeader(Canvas);

	YOffset = 80;

	for ( I=0; I<PlayerCount; I++ )
	{
		if ( YOffset < Canvas.ClipY - 85 )
			DrawPlayerStats( Canvas, Ordered[I], 0, YOffset, false );
		YOffset += 42;
	}
	Canvas.DrawColor = WhiteColor;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;

}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Frags"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
     bSetStart=False
}
